################################################################################
# Crash intro to R
################################################################################

#===============================================================================
# A simple plot
#===============================================================================

# Assume we have an experiment which has lasted for 10 hours. Each hour we have
# measured the O2 concentration in a closed incubation chamber.

# The "seq" function creates a sequential vector
time.vector <- seq(from=0,to=10,by=1)
time.vector

# The concatenation function "c" assembles a vector out of individual numbers
conc.vector <- c(270,250,232,209,193,176,159,145,130,124,113)
conc.vector

# Making a first plot
plot(time.vector,conc.vector)
# Making a nicer plot
plot(time.vector,conc.vector,ylim=c(0,300), xlab="Time [hr]",ylab="O2 concentration [micromol L-1]",main="Data O2 incubation")

# Adding a trendline through first six data points
index <- 1:8 
model.fit <- lm(conc.vector[index] ~  time.vector[index]) # lm = linear model
abline(model.fit, lwd = 2, col = "blue")
